/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;

public class DosOrder
extends ImageOrder {
    private TextBundle textBundle = StorageBundle.getInstance();

    public DosOrder(ByteArrayImageLayout diskImageManager) {
        super(diskImageManager);
    }

    @Override
    public boolean isBlockDevice() {
        return false;
    }

    @Override
    public boolean isTrackAndSectorDevice() {
        return true;
    }

    @Override
    public byte[] readSector(int track, int sector) throws IllegalArgumentException {
        return this.readBytes(this.getOffset(track, sector), 256);
    }

    @Override
    public void writeSector(int track, int sector, byte[] bytes) throws IllegalArgumentException {
        this.writeBytes(this.getOffset(track, sector), bytes);
    }

    protected int getOffset(int track, int sector) throws IllegalArgumentException {
        if (!(this.isSizeApprox(143360) || this.isSizeApprox(819200) || this.isSizeApprox(819264) || track == 0 || sector == 0)) {
            throw new IllegalArgumentException(this.textBundle.get("DosOrder.UnrecognizedFormatError"));
        }
        int offset = (track * this.getSectorsPerTrack() + sector) * 256;
        if (offset > this.getPhysicalSize()) {
            throw new IllegalArgumentException(this.textBundle.format("DosOrder.InvalidSizeError", track, sector));
        }
        return offset;
    }

    @Override
    public byte[] readBlock(int block) {
        int track = block / 8;
        int sectorIndex = block % 8;
        int[] sectorMapping1 = new int[]{0, 13, 11, 9, 7, 5, 3, 1};
        int[] sectorMapping2 = new int[]{14, 12, 10, 8, 6, 4, 2, 15};
        int sector1 = sectorMapping1[sectorIndex];
        int sector2 = sectorMapping2[sectorIndex];
        byte[] blockData = new byte[512];
        System.arraycopy(this.readSector(track, sector1), 0, blockData, 0, 256);
        System.arraycopy(this.readSector(track, sector2), 0, blockData, 256, 256);
        return blockData;
    }

    @Override
    public void writeBlock(int block, byte[] data) {
        int track = block / 8;
        int sectorIndex = block % 8;
        int[] sectorMapping1 = new int[]{0, 13, 11, 9, 7, 5, 3, 1};
        int[] sectorMapping2 = new int[]{14, 12, 10, 8, 6, 4, 2, 15};
        int sector1 = sectorMapping1[sectorIndex];
        int sector2 = sectorMapping2[sectorIndex];
        byte[] sectorData = new byte[256];
        System.arraycopy(data, 0, sectorData, 0, 256);
        this.writeSector(track, sector1, sectorData);
        System.arraycopy(data, 256, sectorData, 0, 256);
        this.writeSector(track, sector2, sectorData);
    }

    @Override
    public String getName() {
        return this.textBundle.get("DosOrder.OrderName");
    }
}

